﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Sprzedaż</title>
		<script runat="server">

    ParametryWydrukuDokumentu parametry;
    [Context]
    public ParametryWydrukuDokumentu Parametry {
        get { return parametry; }
        set { parametry = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;

		// TASK: 2526. [4.3]
		/***
		 * TASK: 5221. [7.3] /sbm
		 * 
		 * dc.AdditionalFooterInfo = true;
		 */
		dc.AdditionalFooterInfo = dokument.Definicja.InformacjeKRS;
		
        SectionDokumentHandlowy.Visible = dokument.DokumentHandlowyNumer!="";
        SectionMagazyn.Visible = dokument.Magazyn!=null && dokument.MagazynDo==null;
        SectionMagazynDo.Visible = dokument.MagazynDo!=null;
    
        //Formatujemy informację o podmiocie
        if (dokument.Kontrahent==null)
            SectionKontrahent.Visible = false;
        else {
            if (dokument.Wydruk.JestOdbiorca)
				kto2.EditValue = "Kontrahent";
			else
				kto2.EditValue = dokument.Definicja.DostawcaOdbiorca;
        }
    
        //Składamy opis do dokumentu
        string opis = "";
        if (dokument.Opis!="")
            opis += "<p>" + dokument.Opis + "</p>";
        if (dokument.Wydruk.OpisWydruku!="")
            opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
        Opis.EditValue = opis;
    
        //Formatujemy podpisy
        stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";

        if (dokument.Platnosci.IsEmpty)
            Grid2.Visible = false;
			
		DataLabel15.EditValue = dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? dokument.Suma.Netto : dokument.Suma.Brutto;
    }
    
    void Grid_BeforeRow(Object sender, RowEventArgs args)
    {
        if(!section15.Visible) 
            if((args.Row as PozycjaDokHandlowego).WartoscCy.Symbol != "PLN")
                section15.Visible = true;
    }
	
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        //Formatujemy nagłówek dokumentu.
        //Może być za każdym razem inny
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        string title = dokument.Definicja.TytulWydruku;
        if (title!="")
            title += " ";
        title += dokument.Numer;
        if (dokument.Wydruk.OpisStanu!="")
			title += "|" + dokument.Wydruk.OpisStanu;
        title += "|" + CaptionAttribute.EnumToString(kopia.Kopia);
        title += "|</STRONG>Data i miejsce wystawienia:<STRONG> " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);
        title += "|</STRONG>Data operacji:<STRONG> " + dokument.DataOperacji;
        if (kopia.Kopia==TypKopiiDokumentu.Duplikat)
            title += "|</STRONG>Data wystawienia duplikatu:<STRONG> " + Date.Today;
    
        ReportHeader1.Title = title;
    }
    
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="Sprzedaż" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel"
				Width="100%">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="true"></ea:PageBreak>
				<cc1:ReportHeader id="ReportHeader1" title="Magazyn" runat="server"></cc1:ReportHeader>

				<ea:Section id="SectionDokumentHandlowy" runat="server" Width="100%">
					<EM>Dokument handlowy: </EM>
					<ea:DataLabel id="DataLabel11" runat="server" DataMember="Dokument.DokumentHandlowyNumer" EncodeHTML="True"></ea:DataLabel>
					<EM>&nbsp;z dnia:</EM>
					<ea:DataLabel id="DataLabel13" runat="server" DataMember="Dokument.DokumentHandlowyData" EncodeHTML="True"></ea:DataLabel>
					<BR>
				</ea:Section>
				<ea:Section id="SectionMagazyn" runat="server" Width="100%">
					<EM>Magazyn: </EM>
					<ea:DataLabel id="DataLabel1" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
					<BR>
				</ea:Section>
				<ea:Section id="SectionMagazynDo" runat="server" Width="100%">
					<EM>Z magazynu: </EM>
					<ea:DataLabel id="DataLabel2" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
					<EM>Do magazynu: </EM>
					<ea:DataLabel id="DataLabel3" runat="server" DataMember="Dokument.MagazynDo" EncodeHTML="True"></ea:DataLabel>
					<BR>
				</ea:Section>
				<ea:Section id="SectionKontrahent" runat="server" Width="100%">
					<EM>
						<TABLE id="Table1" cellSpacing="0" width="100%">
							<TR>
								<TD vAlign="top">
										<!-- Oddział firmy -->
                                        <ea:Section ID="OddzialFirmy" runat="server" 
				                            DataMember="Dokument.Wydruk.JestOddzial">
				                        <em><u>Oddział:</u></em>
				                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative;">
					                    <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Dokument.Wydruk.PieczatkaOddziału.Nazwa" ></ea:DataLabel><br />
					                    <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia1" ></ea:DataLabel><br />
					                    <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia2" ></ea:DataLabel>
				                        </div>
                                        </ea:Section>
                                        <!-- Oddział firmy -->
								</TD>
								<TD vAlign="top"><EM><U>
									<ea:DataLabel id="kto2" runat="server" Bold="False" Font-Italic="True" EncodeHTML="True"></ea:DataLabel>:<BR>
										</U></EM>
									<DIV style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
										<ea:DataLabel id="DataLabel4" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><BR>
										<ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><BR>
										<ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><BR>
										NIP:
										<ea:DataLabel id="DataLabel12" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.EuVAT"></ea:DataLabel></DIV>								
									<ea:Section id="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
										<EM><U>
												<ea:DataLabel id="kto" runat="server" Bold="False" Font-Italic="True" DataMember="Dokument.Definicja.DostawcaOdbiorca" EncodeHTML="True"></ea:DataLabel>:</U></EM>
										<DIV style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
											<ea:DataLabel id="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><BR>
											<ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><BR>
											<ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><BR>
											NIP:
											<ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.EuVAT"></ea:DataLabel></DIV>
									</ea:Section></TD>
							</TR>
						</TABLE>
					</EM>
				</ea:Section>
				
				<div style="margin: 10px 0px 5px 0px">
					<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" DataMember="Dokument.Pozycje" 
					RowsInRow="2" OnBeforeRow="Grid_BeforeRow">
						<Columns>
							<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" runat="server"></ea:GridColumn>
							<ea:GridColumn Width="20" DataMember="Towar.Kod" Caption="Kod towaru" RowSpan="2" runat="server" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn DataMember="NazwaPierwszaLinia" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
							<ea:GridColumn DataMember="NazwaResztaLinii" Caption=" " runat="server"></ea:GridColumn>
							<ea:GridColumn Width="15" Align="Right" DataMember="Cena" Caption="Cena" RowSpan="2" runat="server"></ea:GridColumn>
							<ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="ZmianaIlości.Value" Caption="Ilość"
								RowSpan="2" runat="server"></ea:GridColumn>
							<ea:GridColumn Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server"></ea:GridColumn>
							<ea:GridColumn Width="15" Align="Right" DataMember="ZmianaWartościCy" Total="Sum" Caption="Wartość"
								RowSpan="2" runat="server"></ea:GridColumn>
						</Columns>
					</ea:Grid>
				</div>
				
				<div style="margin: 5px 0px 10px 0px">
					Podsumowanie ilości:
					<ea:DataLabel id="DataLabel14" runat="server" Bold="False" DataMember="Dokument.Wydruk.PodsumowanieIlości">
					</ea:DataLabel>
					<br />
				 
					<ea:Section ID="section15" runat="server" Visible="false">
						Podsumowanie w PLN:
						<ea:DataLabel id="DataLabel15" runat="server" Bold="False">
						</ea:DataLabel>
						<br />
					</ea:Section>
				</div>
                    
				<ea:Grid id="Grid2" runat="server" RowTypeName="Soneta.Kasa.Platnosc,Soneta.Kasa" DataMember="Dokument.Platnosci">
					<Columns>
						<ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"></ea:GridColumn>						
                        <ea:GridColumn ID="GridColumn2" runat="server" Width="20" DataMember="SposobZaplaty" Caption="Spos&#243;b zapłaty"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn3" runat="server" Width="15" Align="Center" DataMember="Termin" Caption="Termin"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn4" runat="server" Width="20" Align="Right" DataMember="Kwota"></ea:GridColumn>
                    </Columns>
				</ea:Grid>
				                        
				<ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryPowiazanych">
					<div style="margin: 5px 0px 5px 0px">
					<em>Dokumenty powiązane:</em>
					<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
						<ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryNadrzędneBK" Bold="False"></ea:DataLabel>
						<ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryPodrzędneBK" Bold="False"></ea:DataLabel>
					</div>
					</div>
				</ea:Section>
				
				<ea:Section runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryKorekt">
					<div style="margin: 5px 0px 5px 0px">
					  <em>Poprzednie korekty:</em>
					  <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
						<ea:DataLabel runat="server" DataMember="Dokument.Wydruk.NumeryPoprzednichKorekt"
						  Bold="false">
						</ea:DataLabel>
					  </div>
					</div>
				</ea:Section>
				</br>
				
				<ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
				
				<cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
					<Subtitles>
						<cc1:FooterSubtitle Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter>
				<ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker></ea:datarepeater>
		</form>
	</body>
</HTML>

